# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Simply think that if we sort according to end points then the starting of next interval must be greater than or equal to end of previous interval. 

# Approach
<!-- Describe your approach to solving the problem. -->
Sort intervals array according to their end points. I have used in built sorting method in java ( with comparator ).

The current( initial ) end point will be offcourse the endpoint of first interval in the sorted intervals array.

Now keep in mind :
- if the starting point of next interval is greater or equal to current end point then it is non-overlapping so no issue, but update the current end value to the current end point of that iterated interval
- otherwise it will cause overlap , so it must be deleted to remove overlapping ; hence increase the count


Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity :  $$O(n* log(n) )$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(n )$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->
Arrays.sort() in java uses this abovesaid complexities.
# Code
```
class Solution {
    public int eraseOverlapIntervals(int[][] intervals) {

        if( intervals.length == 0){
            return 0;
        }

        Arrays.sort( intervals, ( i1, i2) -> i1[1] - i2[1]);           // sorting on the basis of increasing end points of interval
        int d = 0;                                                    // to store how many intervals be deleted to remove overlapping
        int curEnd = intervals[0][1];                                 // current end point will be the end point of first interval
        for( int i = 1; i < intervals.length; i++){
            if( intervals[i][0] >= curEnd){                          // if the starting point of next interval is greater or equal to current end point then it is non-overlapping so no issue, but update the current end value to the current end point of that iterated interval
                curEnd = intervals[i][1];
            }
            else{                                                    // otherwise it will cause overlap , so it must be deleted to remove overlapping ; hence increase the count
                d++;
            }
        }
        return d;
        
    }
}
```